require "BuildingObjects/ISBuildingObject"

HCLogBarricade = ISBuildingObject:derive("HCLogBarricade");

function HCLogBarricade:create(x, y, z, north, sprite, spriteN)
	local cell = getWorld():getCell();
	local eHP = getSpecificPlayer(self.player):getPerkLevel(Perks.Woodwork)*200;
	local objHP = 400 + eHP;
	if getSpecificPlayer(self.player):HasTrait("Handy") then
		objHP = objHP + 100;
	end
	self.sq = cell:getGridSquare(x, y, z);
	self.javaObject = IsoThumpable.new(cell, self.sq, sprite, north, self);
	buildUtil.setInfo(self.javaObject, self);
	local self2 = self;
	self2.modData["need:Hydrocraft.HCLogbarricade"] = "1";
	buildUtil.consumeMaterial(self2);
	self2 = nil;
	self.javaObject:setMaxHealth(objHP);
	self.javaObject:setBreakSound("breakdoor");
	self.sq:AddSpecialObject(self.javaObject);
	self.sq:RecalcAllWithNeighbours(true);
	self.javaObject:transmitCompleteItemToServer();
end

function HCLogBarricade:new(sprite, spriteN, player)
	local o = {};
	setmetatable(o, self);
	self.__index = self;
	o:init();
	o:setSprite(sprite);
	o:setNorthSprite(spriteN);
	o.name = "Log Barricade";
	o.canBarricade = false;
	o.dismantable = false;
	o.blockAllTheSquare = true;
	o.canBeAlwaysPlaced = false;
	o.noNeedHammer = true;
	o.character = player;
	return o;
end

function HCLogBarricade.onDestroy(thump, player)
	if thump:getName() ~= "Log Barricade" then return end
	for x=0, 2+ZombRand(4) do
		thump:getSquare():AddWorldInventoryItem("Base.Log", 0.0, 0.0, 0.0);
	end
	for x=0, ZombRand(2) do
		thump:getSquare():AddWorldInventoryItem("Hydrocraft.HCRopethick", 0.0, 0.0, 0.0);
	end
	thump:getSquare():transmitRemoveItemFromSquare(thump);
	thump:getSquare():RemoveTileObject(thump);
end

function HCLogBarricade:render(x, y, z, square)
	ISBuildingObject.render(self, x, y, z, square);
end

Events.OnDestroyIsoThumpable.Add(HCLogBarricade.onDestroy);